<?php
  BEvent::Hook('on tpl vars: common', array('BFeed', 'CommonVarsTo'));
  BEvent::Hook('on tpl vars: post', array('BFeed', 'PostVarsTo'));

  BEvent::HookInstanceOf('BFeedPage', 'Generate', 'generate page: feed');

  BConfig::$strings += array(
    'feeds: posts'          => '$siteName - posts ($feedFormat)',
    'feeds: comments'       => '$siteName - comments ($feedFormat)',
    'feeds: post comments'  => '$textTitle - comments ($feedFormat)',
  );

/* one-shot */
  $this->name = 'feeds';
  $this->Caption('Ленты новостей', 'ru');
/* install BFeed */
class BFeed {
  static $default = 'RSS20';

  static $posts = array('RSS20', 'RSS092', 'Atom');
  static $comments = array('RSS20', 'RSS092', 'Atom');

  static $postCount = 15;
  static $commentCount = 15;
  static $postCommentCount = 15;

  static protected $titleVars = array();

  // if true, posts will have 'updated' field set - some aggregators will display
  // such on top of others even if their publication date is older than other posts'.
  static $trackUpdated = true;
  // this symbol (can be empty string) is prefixed to comments made by the post author.
  static $authorPrefix = '*';

  static function CommonVarsTo(&$vars) {
    $vars['headFooter'] .= self::Links('posts', null, self::$posts).
                           self::Links('comments', null, self::$comments, 'post=');

    $vars['recentPostsFeed'] = array(
      'format'          => self::$default,
      'title'           => self::TitleOf('posts'),
      'url'             => self::UrlOf(self::$default),
    );

    $vars['recentCommentsFeed'] = array(
      'format'          => self::$default,
      'title'           => self::TitleOf('comments'),
      'url'             => self::UrlOf(self::$default, 'post='),
    );

    switch (BPage::Current()) {
    case 'main':
      $vars['criteria'] .= self::Link(self::UrlOf(self::$default));
      break;
    case 'blog list':
      $url = rtrim(strtok($_SERVER['REQUEST_URI'], '?'), '/').'/feed?format='.self::$default;
      $vars['criteria'] .= self::Link($url);
    }
  }

    static function Link($url) {
      $img = BConfig::$staticURL.'feeds-24.png';

      return ' <a href="'.htmlspecialchars($url).'">'.
               '<img src="'.htmlspecialchars($img).'" alt="'.self::$default.'" />'.
             '</a>';
    }

  static function PostVarsTo(&$vars, $post) {
    $extra = 'post='.urlencode($post);
    $vars['headFooter'] .= self::Links('post comments', $post, self::$comments, $extra);

    if (self::$comments) {
      $format = self::$comments[0];

      $vars['postCommentsFeed'] = array(
        'format'          => $format,
        'title'           => self::TitleOf('post comments', $format, $post),
        'url'             => self::UrlOf($format, $extra),
      );
    }
  }

    static function Links($source, $post, $formats, $extra = '') {
      self::Load();

      foreach ($formats as &$format) {
        $url = htmlspecialchars( self::UrlOf($format, $extra) );
        $title = self::TitleOf($source, $format, $post);

        $format = "<link rel='alternate' type='".FeedOut::MimeOf($format)."' title='$title' href='$url'>";
      }

      return join("\n", $formats)."\n";
    }

  static function UrlOf($format, $extra = '') {
    $extra and $extra = "&$extra";
    $format = strtolower($format);

    return BConfig::$engineURL."feed.php?format=$format$extra";
  }

  static function TitleOf($source, $format = null, $post = null) {
    isset($format) or $format = self::$default;

    $vars = &self::$titleVars[$post];

    if (!isset($vars)) {
      $vars = $post ? BPosts::Get($post) : array();
      Template::AddCommonVars(null, $vars);

      $keys = array();
      foreach ($vars as $key => &$value) { $keys[] = '$'.$key; }
      $vars = array_combine($keys, $vars);
    }

    $vars += array('$feedFormat' => $format);
    return strtr(Translate("feeds: $source"), $vars);
  }

  static function From($channel = array(), $entries = array()) {
    self::Load();

    $feeder = new Feeder;
    $channel and $feeder->Channel()->SetFromArray($channel);

    foreach (array_values($entries) as $i => $entry) {
      $feeder->Entry($i, new FeedEntry($entry));
    }

    return $feeder;
  }

    static function Load() {
      if (!class_exists('Feeder')) {
        $file = dirname(__FILE__).'/feeder.php';
        if (is_file($file)) { require_once $file; }
      }

      if (!class_exists('Feeder')) {
        throw new BException('Cannot load PHP Feeder library for the feeds plugin.',
                             'expected class location: '.$file);
      }
    }

  static function Factory($format) {
    BFeed::Load();
    return FeedOut::Factory($format);
  }

  static function Channel($title, $desc, $permalink) {
    static $sizes = array(64, 128, 48, 32, 24, 16);

    foreach ($sizes as $size) {
      $prop = 'logo'.$size;
      if ($logo = BConfig::$$prop) { break; }
    }

    return array(
      'logo'              => $logo,
      'icon'              => BConfig::$baseURL.'favicon.ico',
      'webmaster'         => BConfig::$adminName. ' '.BConfig::$adminEMail,
      'pubdate'           => time(),
      'ttl'               => 60,
      'title'             => $title,
      'description'       => $desc,
      'copyright'         => BConfig::$copyright,
      'link'              => 'text/html '.BConfig::$siteHome.' '.BConfig::$siteName,
      'permalink'         => $permalink,
      'author'            => BConfig::$adminName. ' '.BConfig::$adminEMail,
      'baseurl'           => BConfig::$baseURL,
    );
  }

  static function GetPosts() {
    $posts = array();

      $name = BPosts::Last();
      $count = self::$postCount;

      while (--$count >= 0 and $name) {
        $posts[] = $name;
        $name = BPosts::PreviousTo($name);
      }

    return self::PostEntries($posts);
  }

    static function PostEntries(array $posts) {
      foreach ($posts as &$name) {
        $post = BPosts::Get($name);

        $info = array(
          'published'         => $post['postTime'],
          'commentsurl'       => BPosts::CanComment($name) ? BPosts::CommentsUrlOf($name) : null,
          'description html'  => $post['shortened'],
          'title'             => $post['textTitle'],
          'title html'        => $post['textTitle'],
          'permalink'         => $post['permalink'],
          'author'            => $post['author'],
        );

        foreach ($post['tags'] as $tag) {
          $info['category'][] = BTags::UrlOf($tag)." $tag ".BTags::CaptionOf($tag);
        }

        if (self::$trackUpdated and $update = &$post['lastChanged']) {
          $info['updated'] = $update;
        }

        $name = $info;
      }

      return $posts;
    }

  static function GetComments() {
    $result = array();

      $name = BComments::Last();
      $count = self::$commentCount;

      while (--$count >= 0 and $name) {
        $result[] = self::CommentEntryOf($name);
        $name = BComments::PreviousTo($name);
      }

    return $result;
  }

    static function CommentEntryOf($name) {
      $post = BComments::PostOf($name);
      $comment = BComments::Get($name);

      $authorPrefix = $comment['isByPostAuthor'] ? self::$authorPrefix : '';
      $titleSuffix = $comment['isByAnonymous'] ? '' : " [$authorPrefix$comment[author]]";

      $entry = array(
        'published'         => $comment['time'],
        'commentsurl'       => BComments::ThreadUrlOf($name),
        'content'           => $comment['source'],
        'content html'      => $comment['text'],
        'title'             => BPosts::TitleOf($post, false).$titleSuffix,
        'title html'        => BPosts::TitleOf($post, true).$titleSuffix,
        'permalink'         => BComments::UrlOf($name),
      );

      if (!$comment['isByAnonymous']) {
        $entry['author'] = "$authorPrefix$comment[author] $comment[authorHome]";
      }

      return $entry;
    }

  static function GetCommentsOf($post) {
    $result = array();

      $name = BComments::LastOf($post);
      $count = self::$postCommentCount;

      while (--$count >= 0 and $name) {
        $result[] = self::CommentEntryOf($name);
        $name = BComments::PreviousOf($post, $name);
      }

    return $result;
  }
}

/* install BFeedPage */
class BFeedPage {
  function Generate($page, $options) {
    $format = &$_GET['format'];
    $format or $format = BFeed::$default;

    $desc = @$options['criteriaDesc'];
    $desc or $desc = BConfig::$siteDesc;

    $url = $options['origRequest'].'?format='.$format;
    $channel = BFeed::Channel($options['criteria'], $desc, $url);

    $entries = BFeed::PostEntries($options['posts']);

    $feed = BFeed::From($channel, $entries);
    BFeed::Factory($format)->Output($feed);

    exit;
  }
}

/* one-shot */
return;
?>

/* install base64:static/feeds-24.png */
iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAD0klEQVR4Xq1WXWwUVRT+7szs7Jbt
WvmRdK2QElswtiq2DUKw+MNbo1GjSdVIeGibEHnhyfggPxp5wQd5AG0kmKiJwItsNPTFBzFaTUz/
EnjYolAotk3bmOLurNvZmTvHuXc6cztsaNBwdk/Omb2Tb873nXP3DsOSDe154Mjqhgf3JhKJRsM0
IRcYwBgTUZpIwwWZB2mUO3YFZcu+vjA1/UXHV/NHEN4+1tNwPtvc/DJfKIC4C01nYL6riCBqwTXT
AE1GmceiuLlkmZi8NJ7benrqFSYq39DSctiZ/UuA/E9wFcECdsVCCteGL71vCFlE5SFoqvV5oFKU
1978FcCx/jO45xJqkjYENps82EF6uRJVvKb3FBKbOhAan7sCfnMYztg5wJq5K3DpDuHW3wRNNFTJ
EXZMmb5+M8z2N5DuySH12qfQ7s/eFTj3o8RmQExzd3JYuKz8dtMb2pDacx7Gtt6VwZdyEEEDQ6yh
i4OfoXRmH0pfvgXr5G7Y338APjUSY2W09yDxwkmwZOZO4NKJAI2xO08Lcy3w/AAqubdR+XY/qDiD
0Fj2SehdJ0B6uho8YoCQgQJPv9mPdHc/al76CIm218FqMlIOmhmB881eeL8PqIesaYbW+V41uGIA
A4hXLj76hjZIe/gZYFsf3Mvn4PkuGf10FLKopq6gL5t2QX+8G85vZ6oeAJOERIjJAoa4JWuV5ms3
S83dHz4EH7+A0MwdvUC6vprBkkSxTWQPvAPb19wdPB7XfG0zDKF5XZMEsC9+DK8g12WzUzv74gx4
2APctkMdCzQzCu5L4px9FXzkNFSptdB3+ZprafBSEfbgKUV064tgmfoInNQUrbz9vbHPpe6haet8
Jr7mAmhx9Dt4txRLc8uzIbiMAAkGMVA5NcbOA1JzrbVbas7zF+AOKSZiusLxLP/6tWLx6HMheCQR
5o49Tf+ceIrKn2ynxf7t5DePlpv7y3G5VurfTd5iIVoo5g7T3ME2mj/WFbv/xv7HaGJfK13ra6E/
D+0gIVGcQSaL5cY2doo5l5o7l9XkGBvbJQNnfhpeuah+z24BcfIdYZMR0xyVIpabe/XHaBNV8hdV
L+qyUUOdqXFVULJWgnseBYWIY47V6dFhwX8+Cs22xFzLPzx76KzaOKUCnIlhEEnQqKGVm3mQF2jO
raIEJw9wXQfs6rtPTDzUlGlkzFvpj6va1bQEuXRE4LppAOvYdU0c0CXLvJfgks2qxtUQ2Jo4/cUB
Lc5Qj2v3pPL7HlmP2Yk/cgK76rUltSopX1tAJL4AybT6GqRy4Qg05+TEXlv+BeMrDuMwThhjAAAA
AElFTkSuQmCC

/* install feed.php */
<?php
require 'engine/page.php';

$format = &$_GET['format'];
$format or $format = BFeed::$default;

$post = &$_GET['post'];
if (!isset($post)) {
  $func = 'GetPosts';

  $title = BFeed::TitleOf('posts', $format);
  $desc = BConfig::$siteDesc;
} elseif ("$post" === '') {
  $func = 'GetComments';

  $title = BFeed::TitleOf('comments', $format);
  $desc = BConfig::$siteDesc;
} else {
  $func = 'GetCommentsOf';

  $title = BFeed::TitleOf('post comments', $format, $post);
  $desc = BPosts::Get($post, 'nutshell');
  $desc or $desc = BPosts::Get($post, 'synopsis');
}

$url = BFeed::UrlOf($format, "$post" === '' ? '' : "post=$post");
$channel = BFeed::Channel($title, $desc, $url);

$entries = BFeed::$func($post);

$feed = BFeed::From($channel, $entries);
BFeed::Factory($format)->Output($feed);
